<?php
/**
 * Plugin Name: Scroll Box Addon for Elementor
 * Description: Adds a scrollable box widget to Elementor.
 * Version: 1.0
 * Author: Nipun AKASH
 */

if ( ! defined( 'ABSPATH' ) ) exit;

final class Scroll_Box_Addon {
    const VERSION = '1.0';
    const MINIMUM_ELEMENTOR_VERSION = '3.0.0';
    const MINIMUM_PHP_VERSION = '7.4';

    private static $_instance = null;

    public static function instance() {
        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    public function __construct() {
        add_action( 'plugins_loaded', [ $this, 'init' ] );

        // ✅ Enqueue CSS
        add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_styles' ] );
    }

    public function init() {
        // Load widget only after Elementor is loaded
        add_action( 'elementor/widgets/register', [ $this, 'register_widgets' ] );
    }

    public function register_widgets( $widgets_manager ) {
        require_once( __DIR__ . '/includes/widget-scroll-box.php' );
        $widgets_manager->register( new \Scroll_Box_Widget() );
    }

    // ✅ Enqueue CSS function
    public function enqueue_styles() {
        wp_enqueue_style(
            'scroll-box-addon',
            plugin_dir_url( __FILE__ ) . 'assets/style.css'
        );
    }
}

Scroll_Box_Addon::instance();
