<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Scroll_Box_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'scroll_box';
    }

    public function get_title() {
        return __( 'Scroll Box', 'scroll-box-addon' );
    }

    public function get_icon() {
        return 'eicon-scroll';
    }

    public function get_categories() {
        return [ 'basic' ];
    }

    protected function register_controls() {
        // Content Section
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'scroll-box-addon' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'scroll_content',
            [
                'label'   => __( 'Content', 'scroll-box-addon' ),
                'type'    => \Elementor\Controls_Manager::WYSIWYG,
                'default' => __( 'Your scrollable content here...', 'scroll-box-addon' ),
            ]
        );

        $this->add_control(
            'height',
            [
                'label'   => __( 'Box Height (px)', 'scroll-box-addon' ),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 200,
            ]
        );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'style_section',
            [
                'label' => __( 'Scrollbar Style', 'scroll-box-addon' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'scrollbar_width',
            [
                'label'   => __( 'Scrollbar Width (px)', 'scroll-box-addon' ),
                'type'    => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range'   => [
                    'px' => [ 'min' => 5, 'max' => 30 ],
                ],
                'default' => [ 'size' => 8 ],
                'selectors' => [
                    '{{WRAPPER}} .scroll-box::-webkit-scrollbar' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'scrollbar_thumb_color',
            [
                'label'   => __( 'Thumb Color', 'scroll-box-addon' ),
                'type'    => \Elementor\Controls_Manager::COLOR,
                'default' => '#999999',
                'selectors' => [
                    '{{WRAPPER}} .scroll-box::-webkit-scrollbar-thumb' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'scrollbar_track_color',
            [
                'label'   => __( 'Track Color', 'scroll-box-addon' ),
                'type'    => \Elementor\Controls_Manager::COLOR,
                'default' => '#e0e0e0',
                'selectors' => [
                    '{{WRAPPER}} .scroll-box::-webkit-scrollbar-track' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
    $settings = $this->get_settings_for_display();

    // Get custom scrollbar values
    $width  = isset($settings['scrollbar_width']['size']) ? $settings['scrollbar_width']['size'] : 8;
    $thumb  = !empty($settings['scrollbar_thumb_color']) ? $settings['scrollbar_thumb_color'] : '#999999';
    $track  = !empty($settings['scrollbar_track_color']) ? $settings['scrollbar_track_color'] : '#e0e0e0';

    // Unique ID so multiple widgets don’t clash
    $unique_id = 'scroll-box-' . $this->get_id();
    ?>
    
    <style>
        #<?php echo $unique_id; ?>::-webkit-scrollbar {
            width: <?php echo $width; ?>px;
        }
        #<?php echo $unique_id; ?>::-webkit-scrollbar-thumb {
            background-color: <?php echo $thumb; ?>;
            border-radius: 4px;
        }
        #<?php echo $unique_id; ?>::-webkit-scrollbar-track {
            background-color: <?php echo $track; ?>;
        }

        /* Firefox support */
        #<?php echo $unique_id; ?> {
            scrollbar-width: thin;
            scrollbar-color: <?php echo $thumb; ?> <?php echo $track; ?>;
        }
    </style>

    <div id="<?php echo $unique_id; ?>" class="scroll-box" style="max-height:<?php echo $settings['height']; ?>px; overflow-y:auto;">
        <?php echo $settings['scroll_content']; ?>
    </div>
    <?php
}

}
